/*! osc.js 2.4.1, Copyright 2021 Colin Clark | github.com/colinbdclark/osc.js */


var osc = osc || {};

!function() {
    "use strict";
    osc.SECS_70YRS = 2208988800, osc.TWO_32 = 4294967296, osc.defaults = {
        metadata: !1,
        unpackSingleArgs: !0
    }, osc.isCommonJS = !("undefined" == typeof module || !module.exports), osc.isNode = osc.isCommonJS && "undefined" == typeof window, 
    osc.isElectron = !("undefined" == typeof process || !process.versions || !process.versions.electron), 
    osc.isBufferEnv = osc.isNode || osc.isElectron, osc.isArray = function(e) {
        return e && "[object Array]" === Object.prototype.toString.call(e);
    }, osc.isTypedArrayView = function(e) {
        return e.buffer && e.buffer instanceof ArrayBuffer;
    }, osc.isBuffer = function(e) {
        return osc.isBufferEnv && e instanceof Buffer;
    }, osc.Long = "undefined" != typeof Long ? Long : osc.isNode ? require("long") : void 0, 
    osc.TextDecoder = "undefined" != typeof TextDecoder ? new TextDecoder("utf-8") : "undefined" != typeof util && (util.TextDecoder, 
    1) ? new util.TextDecoder("utf-8") : void 0, osc.TextEncoder = "undefined" != typeof TextEncoder ? new TextEncoder("utf-8") : "undefined" != typeof util && (util.TextEncoder, 
    1) ? new util.TextEncoder("utf-8") : void 0, osc.dataView = function(e, r, t) {
        return e.buffer ? new DataView(e.buffer, r, t) : e instanceof ArrayBuffer ? new DataView(e, r, t) : new DataView(new Uint8Array(e), r, t);
    }, osc.byteArray = function(e) {
        if (e instanceof Uint8Array) return e;
        var r = e.buffer || e;
        if (!(r instanceof ArrayBuffer || void 0 !== r.length && "string" != typeof r)) throw new Error("Can't wrap a non-array-like object as Uint8Array. Object was: " + JSON.stringify(e, null, 2));
        return new Uint8Array(r);
    }, osc.nativeBuffer = function(e) {
        return osc.isBufferEnv ? osc.isBuffer(e) ? e : Buffer.from(e.buffer ? e : new Uint8Array(e)) : osc.isTypedArrayView(e) ? e : new Uint8Array(e);
    }, osc.copyByteArray = function(e, r, t) {
        if (osc.isTypedArrayView(e) && osc.isTypedArrayView(r)) r.set(e, t); else for (var n = void 0 === t ? 0 : t, o = Math.min(r.length - t, e.length), a = 0, i = n; a < o; a++, 
        i++) r[i] = e[a];
        return r;
    }, osc.readString = function(e, r) {
        for (var t = [], n = r.idx; n < e.byteLength; n++) {
            var o = e.getUint8(n);
            if (0 === o) {
                n++;
                break;
            }
            t.push(o);
        }
        return r.idx = n = n + 3 & -4, (osc.isBufferEnv ? osc.readString.withBuffer : osc.TextDecoder ? osc.readString.withTextDecoder : osc.readString.raw)(t);
    }, osc.readString.raw = function(e) {
        for (var r = "", t = 0; t < e.length; t += 1e4) r += String.fromCharCode.apply(null, e.slice(t, t + 1e4));
        return r;
    }, osc.readString.withTextDecoder = function(e) {
        e = new Int8Array(e);
        return osc.TextDecoder.decode(e);
    }, osc.readString.withBuffer = function(e) {
        return Buffer.from(e).toString("utf-8");
    }, osc.writeString = function(e) {
        var r, t = e + "\0", e = t.length, n = new Uint8Array(e + 3 & -4), o = osc.isBufferEnv ? osc.writeString.withBuffer : osc.TextEncoder ? osc.writeString.withTextEncoder : null;
        o && (r = o(t));
        for (var a = 0; a < t.length; a++) {
            var i = o ? r[a] : t.charCodeAt(a);
            n[a] = i;
        }
        return n;
    }, osc.writeString.withTextEncoder = function(e) {
        return osc.TextEncoder.encode(e);
    }, osc.writeString.withBuffer = function(e) {
        return Buffer.from(e);
    }, osc.readPrimitive = function(e, r, t, n) {
        r = e[r](n.idx, !1);
        return n.idx += t, r;
    }, osc.writePrimitive = function(e, r, t, n, o) {
        var a;
        return o = void 0 === o ? 0 : o, r ? a = new Uint8Array(r.buffer) : (a = new Uint8Array(n), 
        r = new DataView(a.buffer)), r[t](o, e, !1), a;
    }, osc.readInt32 = function(e, r) {
        return osc.readPrimitive(e, "getInt32", 4, r);
    }, osc.writeInt32 = function(e, r, t) {
        return osc.writePrimitive(e, r, "setInt32", 4, t);
    }, osc.readInt64 = function(e, r) {
        var t = osc.readPrimitive(e, "getInt32", 4, r), r = osc.readPrimitive(e, "getInt32", 4, r);
        return osc.Long ? new osc.Long(r, t) : {
            high: t,
            low: r,
            unsigned: !1
        };
    }, osc.writeInt64 = function(e, r, t) {
        var n = new Uint8Array(8);
        return n.set(osc.writePrimitive(e.high, r, "setInt32", 4, t), 0), n.set(osc.writePrimitive(e.low, r, "setInt32", 4, t + 4), 4), 
        n;
    }, osc.readFloat32 = function(e, r) {
        return osc.readPrimitive(e, "getFloat32", 4, r);
    }, osc.writeFloat32 = function(e, r, t) {
        return osc.writePrimitive(e, r, "setFloat32", 4, t);
    }, osc.readFloat64 = function(e, r) {
        return osc.readPrimitive(e, "getFloat64", 8, r);
    }, osc.writeFloat64 = function(e, r, t) {
        return osc.writePrimitive(e, r, "setFloat64", 8, t);
    }, osc.readChar32 = function(e, r) {
        r = osc.readPrimitive(e, "getUint32", 4, r);
        return String.fromCharCode(r);
    }, osc.writeChar32 = function(e, r, t) {
        e = e.charCodeAt(0);
        if (!(void 0 === e || e < -1)) return osc.writePrimitive(e, r, "setUint32", 4, t);
    }, osc.readBlob = function(e, r) {
        var t = osc.readInt32(e, r), n = t + 3 & -4, t = new Uint8Array(e.buffer, r.idx, t);
        return r.idx += n, t;
    }, osc.writeBlob = function(e) {
        var r = (e = osc.byteArray(e)).byteLength, t = new Uint8Array(4 + (r + 3 & -4)), n = new DataView(t.buffer);
        return osc.writeInt32(r, n), t.set(e, 4), t;
    }, osc.readMIDIBytes = function(e, r) {
        e = new Uint8Array(e.buffer, r.idx, 4);
        return r.idx += 4, e;
    }, osc.writeMIDIBytes = function(e) {
        e = osc.byteArray(e);
        var r = new Uint8Array(4);
        return r.set(e), r;
    }, osc.readColor = function(e, r) {
        var t = new Uint8Array(e.buffer, r.idx, 4), e = t[3] / 255;
        return r.idx += 4, {
            r: t[0],
            g: t[1],
            b: t[2],
            a: e
        };
    }, osc.writeColor = function(e) {
        var r = Math.round(255 * e.a);
        return new Uint8Array([ e.r, e.g, e.b, r ]);
    }, osc.readTrue = function() {
        return !0;
    }, osc.readFalse = function() {
        return !1;
    }, osc.readNull = function() {
        return null;
    }, osc.readImpulse = function() {
        return 1;
    }, osc.readTimeTag = function(e, r) {
        var t = osc.readPrimitive(e, "getUint32", 4, r), r = osc.readPrimitive(e, "getUint32", 4, r);
        return {
            raw: [ t, r ],
            native: 0 === t && 1 === r ? Date.now() : osc.ntpToJSTime(t, r)
        };
    }, osc.writeTimeTag = function(e) {
        var r = e.raw || osc.jsToNTPTime(e.native), t = new Uint8Array(8), e = new DataView(t.buffer);
        return osc.writeInt32(r[0], e, 0), osc.writeInt32(r[1], e, 4), t;
    }, osc.timeTag = function(e, r) {
        e = e || 0;
        var t = (r = r || Date.now()) / 1e3, n = Math.floor(t), r = t - n, t = Math.floor(e), r = r + (e - t);
        return 1 < r && (t += e = Math.floor(r), r = r - e), {
            raw: [ n + t + osc.SECS_70YRS, Math.round(osc.TWO_32 * r) ]
        };
    }, osc.ntpToJSTime = function(e, r) {
        return 1e3 * (e - osc.SECS_70YRS + r / osc.TWO_32);
    }, osc.jsToNTPTime = function(e) {
        var r = e / 1e3, e = Math.floor(r);
        return [ e + osc.SECS_70YRS, Math.round(osc.TWO_32 * (r - e)) ];
    }, osc.readArguments = function(e, r, t) {
        var n = osc.readString(e, t);
        if (0 !== n.indexOf(",")) throw new Error("A malformed type tag string was found while reading the arguments of an OSC message. String was: " + n, " at offset: " + t.idx);
        var o = n.substring(1).split(""), a = [];
        return osc.readArgumentsIntoArray(a, o, n, e, r, t), a;
    }, osc.readArgument = function(e, r, t, n, o) {
        var a = osc.argumentTypes[e];
        if (!a) throw new Error("'" + e + "' is not a valid OSC type tag. Type tag string was: " + r);
        a = a.reader, o = osc[a](t, o);
        return o = n.metadata ? {
            type: e,
            value: o
        } : o;
    }, osc.readArgumentsIntoArray = function(e, r, t, n, o, a) {
        for (var i = 0; i < r.length; ) {
            var s = r[i];
            if ("[" === s) {
                var c = r.slice(i + 1), u = c.indexOf("]");
                if (u < 0) throw new Error("Invalid argument type tag: an open array type tag ('[') was found without a matching close array tag ('[]'). Type tag was: " + t);
                var c = c.slice(0, u), c = osc.readArgumentsIntoArray([], c, t, n, o, a);
                i += u + 2;
            } else c = osc.readArgument(s, t, n, o, a), i++;
            e.push(c);
        }
        return e;
    }, osc.writeArguments = function(e, r) {
        r = osc.collectArguments(e, r);
        return osc.joinParts(r);
    }, osc.joinParts = function(e) {
        for (var r = new Uint8Array(e.byteLength), t = e.parts, n = 0, o = 0; o < t.length; o++) {
            var a = t[o];
            osc.copyByteArray(a, r, n), n += a.length;
        }
        return r;
    }, osc.addDataPart = function(e, r) {
        r.parts.push(e), r.byteLength += e.length;
    }, osc.writeArrayArguments = function(e, r) {
        for (var t = "[", n = 0; n < e.length; n++) {
            var o = e[n];
            t += osc.writeArgument(o, r);
        }
        return t += "]";
    }, osc.writeArgument = function(e, r) {
        if (osc.isArray(e)) return osc.writeArrayArguments(e, r);
        var t = e.type, t = osc.argumentTypes[t].writer;
        return t && (t = osc[t](e.value), osc.addDataPart(t, r)), e.type;
    }, osc.collectArguments = function(e, r, t) {
        osc.isArray(e) || (e = void 0 === e ? [] : [ e ]), t = t || {
            byteLength: 0,
            parts: []
        }, r.metadata || (e = osc.annotateArguments(e));
        for (var n = ",", o = t.parts.length, a = 0; a < e.length; a++) {
            var i = e[a];
            n += osc.writeArgument(i, t);
        }
        r = osc.writeString(n);
        return t.byteLength += r.byteLength, t.parts.splice(o, 0, r), t;
    }, osc.readMessage = function(e, r, t) {
        r = r || osc.defaults;
        var n = osc.dataView(e, e.byteOffset, e.byteLength), e = osc.readString(n, t = t || {
            idx: 0
        });
        return osc.readMessageContents(e, n, r, t);
    }, osc.readMessageContents = function(e, r, t, n) {
        if (0 !== e.indexOf("/")) throw new Error("A malformed OSC address was found while reading an OSC message. String was: " + e);
        n = osc.readArguments(r, t, n);
        return {
            address: e,
            args: 1 === n.length && t.unpackSingleArgs ? n[0] : n
        };
    }, osc.collectMessageParts = function(e, r, t) {
        return t = t || {
            byteLength: 0,
            parts: []
        }, osc.addDataPart(osc.writeString(e.address), t), osc.collectArguments(e.args, r, t);
    }, osc.writeMessage = function(e, r) {
        if (r = r || osc.defaults, !osc.isValidMessage(e)) throw new Error("An OSC message must contain a valid address. Message was: " + JSON.stringify(e, null, 2));
        r = osc.collectMessageParts(e, r);
        return osc.joinParts(r);
    }, osc.isValidMessage = function(e) {
        return e.address && 0 === e.address.indexOf("/");
    }, osc.readBundle = function(e, r, t) {
        return osc.readPacket(e, r, t);
    }, osc.collectBundlePackets = function(e, r, t) {
        t = t || {
            byteLength: 0,
            parts: []
        }, osc.addDataPart(osc.writeString("#bundle"), t), osc.addDataPart(osc.writeTimeTag(e.timeTag), t);
        for (var n = 0; n < e.packets.length; n++) {
            var o = e.packets[n], o = (o.address ? osc.collectMessageParts : osc.collectBundlePackets)(o, r);
            t.byteLength += o.byteLength, osc.addDataPart(osc.writeInt32(o.byteLength), t), 
            t.parts = t.parts.concat(o.parts);
        }
        return t;
    }, osc.writeBundle = function(e, r) {
        if (!osc.isValidBundle(e)) throw new Error("An OSC bundle must contain 'timeTag' and 'packets' properties. Bundle was: " + JSON.stringify(e, null, 2));
        r = r || osc.defaults;
        r = osc.collectBundlePackets(e, r);
        return osc.joinParts(r);
    }, osc.isValidBundle = function(e) {
        return void 0 !== e.timeTag && void 0 !== e.packets;
    }, osc.readBundleContents = function(e, r, t, n) {
        for (var o = osc.readTimeTag(e, t), a = []; t.idx < n; ) {
            var i = osc.readInt32(e, t), i = t.idx + i, i = osc.readPacket(e, r, t, i);
            a.push(i);
        }
        return {
            timeTag: o,
            packets: a
        };
    }, osc.readPacket = function(e, r, t, n) {
        var o = osc.dataView(e, e.byteOffset, e.byteLength);
        n = void 0 === n ? o.byteLength : n;
        var a = osc.readString(o, t = t || {
            idx: 0
        }), e = a[0];
        if ("#" === e) return osc.readBundleContents(o, r, t, n);
        if ("/" === e) return osc.readMessageContents(a, o, r, t);
        throw new Error("The header of an OSC packet didn't contain an OSC address or a #bundle string. Header was: " + a);
    }, osc.writePacket = function(e, r) {
        if (osc.isValidMessage(e)) return osc.writeMessage(e, r);
        if (osc.isValidBundle(e)) return osc.writeBundle(e, r);
        throw new Error("The specified packet was not recognized as a valid OSC message or bundle. Packet was: " + JSON.stringify(e, null, 2));
    }, osc.argumentTypes = {
        i: {
            reader: "readInt32",
            writer: "writeInt32"
        },
        h: {
            reader: "readInt64",
            writer: "writeInt64"
        },
        f: {
            reader: "readFloat32",
            writer: "writeFloat32"
        },
        s: {
            reader: "readString",
            writer: "writeString"
        },
        S: {
            reader: "readString",
            writer: "writeString"
        },
        b: {
            reader: "readBlob",
            writer: "writeBlob"
        },
        t: {
            reader: "readTimeTag",
            writer: "writeTimeTag"
        },
        T: {
            reader: "readTrue"
        },
        F: {
            reader: "readFalse"
        },
        N: {
            reader: "readNull"
        },
        I: {
            reader: "readImpulse"
        },
        d: {
            reader: "readFloat64",
            writer: "writeFloat64"
        },
        c: {
            reader: "readChar32",
            writer: "writeChar32"
        },
        r: {
            reader: "readColor",
            writer: "writeColor"
        },
        m: {
            reader: "readMIDIBytes",
            writer: "writeMIDIBytes"
        }
    }, osc.inferTypeForArgument = function(e) {
        switch (typeof e) {
          case "boolean":
            return e ? "T" : "F";

          case "string":
            return "s";

          case "number":
            return "f";

          case "undefined":
            return "N";

          case "object":
            if (null === e) return "N";
            if (e instanceof Uint8Array || e instanceof ArrayBuffer) return "b";
            if ("number" == typeof e.high && "number" == typeof e.low) return "h";
        }
        throw new Error("Can't infer OSC argument type for value: " + JSON.stringify(e, null, 2));
    }, osc.annotateArguments = function(e) {
        for (var r = [], t = 0; t < e.length; t++) {
            var n = e[t];
            n = "object" == typeof n && n.type && void 0 !== n.value ? n : osc.isArray(n) ? osc.annotateArguments(n) : {
                type: osc.inferTypeForArgument(n),
                value: n
            }, r.push(n);
        }
        return r;
    }, osc.isCommonJS && (module.exports = osc);
}();